# ASI Lean4 Pure Benchmark

This package contains the pure open-problem subset of the ASI Lean4 benchmark.

## Contents

- `benchmark/manifest.json` — benchmark metadata
- `benchmark/pure_problems.json` — all pure problems (300 total)
- `benchmark/banned_tokens.txt` — disallowed tokens
- `benchmark/submission_schema.json` — automated submission API schema
- `benchmark/submission_example.json` — example payload
- `verifier/verify_single_example.sh` — single-problem compile example
- `verifier/direct_api_agent_example.sh` — direct API agent harness example
- `verifier/submit_api_example.sh` — cURL example for automated submissions

## Environment

- Lean: 4.27.0
- Mathlib: v4.27.0
- Verification: zero-trust compilation (warningAsError=true, 19 banned tokens)

## Quickstart

1. Clone formal-conjectures and install elan.
2. For each problem, generate a tactic body (the lines after `:= by`).
3. Compile with:

```bash
source ~/.elan/env
cd /path/to/formal-conjectures
lake lean /path/to/your_proof.lean
```

## Notes

- Banned tokens are checked before compilation.
- This package is generated from the live ASI Prize database.
- Generated at: 2026-03-02T15:50:40.568448+00:00
- Automated submissions: POST JSON to `/api/submissions/` with `X-ASI-Submit-Token`.
